%%%%%%%%%%%% Process the sequences in the training corpus %%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Follows "prepareTrainingCorpus.mat" %%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% Select exercise 1 to X (6 or 8) %%%%%
lastExerciseNumber = 6;
processedCorpus = [];
for classIndex = 1:lastExerciseNumber
    exerciseIndices = ismember([trainingCorpus{:,3}], ...
                                exerciseClasses(classIndex));
    processedCorpus = [processedCorpus; ...
                       trainingCorpus(exerciseIndices,:)];
end
%%%%% FIR Low-pass filter the signals %%%%%
fs_Hz = 100; % sampling frequency
fc_Hz = 10;  % corner frequency
firFilterOrder = 20; 
filterLength = firFilterOrder + 1; % 21 tap fir filter
[a,b] = firLPFilter(fs_Hz,fc_Hz,firFilterOrder/2,0); 
signalLength = 500;

%% %%%%%%%%%%%% filter all raw sensor sequences %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% get the channel number from the first file %%%%%
[numChannels,numFrames] = size(processedCorpus{1,1}); 
numSequences = length(processedCorpus);
fprintf("Filtering recordings...");
sequenceFiltered  = zeros(9,signalLength); % allocated array for filtered 
                                           % sequence signal in each channel 
for seqIdx = 1:numSequences
%%%%% filtering with LP filter %%%%%
    sequence = processedCorpus{seqIdx,1}; % current sequence being processed
    for(chIdx = 1:numChannels)
        %%%%% pad the borders with half the filter length and the %%%%%
        %%%%% values at the first/last sample, respectively:      %%%%%
        % first value is always zero, omit that one:
        sequencePaddingLeft = ones(9,firFilterOrder/2+1).*sequence(:,2); 
        sequencePaddingRight = ones(9,firFilterOrder/2).*sequence(:,end);
        sequenceToFilt = [sequencePaddingLeft, ...
                          sequence(:,2:end), ...
                          sequencePaddingRight];
        filteredSignal = filtfilt(b,a,sequenceToFilt(chIdx,:));
        sequenceFiltered(chIdx,:) = ...
                         filteredSignal(firFilterOrder/2+1:end-firFilterOrder/2);
    end
    processedCorpus{seqIdx,6} = sequenceFiltered; 
end
fprintf("Done.\n");

%% %%%%% Crop the sequences w.r.t. their boundary labels %%%%%%%%%%%%%%%%%%
for seqIdx = 1:numSequences
    % crop the training sequences:
    trainSeqBoundaries = processedCorpus{seqIdx, 2};
    startIdx = trainSeqBoundaries.start;
    stopIdx  = trainSeqBoundaries.end;
    processedCorpus{seqIdx,6} = processedCorpus{seqIdx,6}(:, startIdx:stopIdx);
end

%%%%%%%%%%%%%%%%%% Final processed Corpus structure: %%%%%%%%%%%%%%%%%%%%%%
% Column 1: raw sequence
% Column 2: boundary labels from .lab file
% Column 3: Class label as strings
% Column 4: Participant tag
% Column 5: Participant tag as numeric value
% Column 6: Post-processed and cropped sequence

%% %%%%%% Optionally save the corpus as .mat cell array: %%%%%%%%%%%%%%%%%%
saveProcessedCorpus = false;
if(saveProcessedCorpus)
   if(lastExerciseNumber == 8)
        save("processedCorpusAllEx.mat","processedCorpus");
   elseif(lastExerciseNumber == 6)
       save("processedCorpus.mat","processedCorpus");
   else
       fprintf("lastExerciseNumber (%d) is neither 6 nor 8, \nno corpus saved.\n", ...
                lastExerciseNumber);
   end
end