%%%%%%%%%%%%%%%%%% Prepare the training corpus %%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;clc;close all;
relativeCorpusPath = "..\\Corpus";
% Define necessary variables:
exerciseIDs = [1,2,3,4,5,6,7,107];
exerciseClasses = {'raise_tongue', ...
                           'swipe_tongue_med', ...
                           'click_tongue', ...
                           'swipe_tongue_rl', ...
                           'hawk', ...
                           'ch', ...
                           'clean_left', ...
                           'clean_right'};                  
exerciseTitles = {'Raise tongue tip', ...
                  'Swipe tongue tip towards soft palate', ...
                  'Click tongue', ...
                  'Swipe tongue along inner teeth (R->L)', ...
                  'Articulate \\Hawk\\','Articulate \\ch\\', ...
                  'Clean right cheeck pouch', ...
                  'Clean left cheek pouch'};   
participantIDs = {'PR0002','PR0004','PR0006','PR0009', ...
                  'PR0011','PR0012','PR0016','PR0017', ...
                  'PR0018'};
exerciseTags = {'EX0001','EX0002','EX0003','EX0004', ...
                'EX0005','EX0006','EX0007','EX0107'};
numExercises = length(exerciseTitles);
numParticipants = numel(participantIDs);
sensorDataFilesPaths = cell(1,numParticipants);
labelDataFilesPaths = cell(1,numParticipants);
corpusInformation = struct();
corpusInformation.exerciseIDs = exerciseIDs;
corpusInformation.exerciseTitles = exerciseTitles;
corpusInformation.participantIDs = participantIDs;
corpusInformation.exerciseTags = exerciseTags;

%% %%%%%%%%%%%%%%% Collect the file info (location) %%%%%%%%%%%%%%%%%%%%%%%
if(~exist(relativeCorpusPath + "\\tongueGestureCorpus",'dir'))
    unzip(relativeCorpusPath + "\\tongueGestureCorpus.zip", ...
          relativeCorpusPath);
end

for participant = 1:numParticipants
    participantID = participantIDs{participant};
    validDataPath = sprintf("%s\\tongueGestureCorpus\\sensor\\%s\\validData",...
                            relativeCorpusPath, participantID);
    validLabelPath = sprintf("%s\\tongueGestureCorpus\\labels\\%s\\validData",...
                             relativeCorpusPath, participantID);
    currentSensorFiles = dir(sprintf("%s\\EX*",validDataPath));
    currentLabelFiles = dir(sprintf("%s\\EX*",validLabelPath));

    sensorDataFilesPaths{1,participant} = currentSensorFiles;
    labelDataFilesPaths{1,participant} = currentLabelFiles;
    numOfSensorDataFiles = length(currentSensorFiles); 
    numOfLabelFiles = length(currentLabelFiles);
    if(~(numOfSensorDataFiles == numOfLabelFiles))
       error("Number of sensor data and label files do not match!"); 
    end
end
corpusInformation.sensorDataFilesPaths = sensorDataFilesPaths;
corpusInformation.labelDataFilesPaths = labelDataFilesPaths;

%% %%%%%%%%%%%%%%%%% Load the corpus sequences into memory %%%%%%%%%%%%%%%%
trainingCorpus = [];
numFilesPerParticipant = zeros(1,numParticipants);

for participant = 1:numParticipants
    numFilesPerParticipant(participant) = length(sensorDataFilesPaths{participant});
    participantData = cell(numFilesPerParticipant(participant),3);

    % load all sensor and label data for "participant":
    for fileIdx = 1:numFilesPerParticipant(participant)
        sensorFileName = sensorDataFilesPaths{participant}(fileIdx).name;
        sensorFilePath = sensorDataFilesPaths{participant}(fileIdx).folder;
        labelFileName = labelDataFilesPaths{participant}(fileIdx).name;
        labelFilePath = labelDataFilesPaths{participant}(fileIdx).folder;
        currSensorData = csvread(sprintf("%s\\%s",sensorFilePath,sensorFileName));
        currLabels = fileread(sprintf("%s\\%s",labelFilePath,labelFileName));
        currBoundaryLabels = jsondecode(currLabels);
        currExerciseID = str2double(sensorFileName(3:6));
        % count the number of exercises
        classLabelIndex = find(exerciseIDs == currExerciseID);
        if(currBoundaryLabels.start == 1 && currBoundaryLabels.end == 500)
            warning("Annotated sensor data file %s has indices [start,end] = [1,500]",...
                    sensorFileName);
        end
        participantData{fileIdx,1} = currSensorData';
        participantData{fileIdx,2} = currBoundaryLabels;
        participantData{fileIdx,3} = exerciseClasses(classLabelIndex);
        participantData{fileIdx,4} = participantIDs{participant};
        participantData{fileIdx,5} = participant;
    end
    trainingCorpus = [trainingCorpus;participantData];
end

    