function [a,bh] = firLPFilter(fs,fc,s,plotResponse)
	% calculates the coefficients for a hann-windowed,
	% asymmetric FIR-Lowpass Filter
	% fs: sampling frequency [Hz]
	% fc: center frequency [Hz]
	% s:  number of coefficients around +- zero (needs to be even)
	% plotResponse: plot the filter response, (yes = 1, no = 0)
	if(mod(s,2) == 0)
			ws = fs*2*pi; % radial frequency, [rad/s]
			Ws = ws/fs; % normalized radial frequency, [rad]
			wc = 2*pi*fc; % center radial frequency, [rad/s]
			Wc = wc/fs; % normalized radial center frequency, [rad]
			% if corner frequency cannot be met: increase sampling rate or filter length
			L = 2*s + 1; % total number of coefficients
			M = L-1; % order of the filter
			k = -s:s;
			x = Wc/pi*sinc(k*Wc/pi);
			b = x;
			a = 1;
			% Hann window:
			% for k = 0:L-1
			%     w(k+1) = 1/2*(1-cos(2*pi*k/(L-1))); % manual calculation
			% end
			w = hann(L);
			bh = b.*w'; % windowed Impulse response (coefficients)
			b0 = sum(bh);
			bh = bh./b0;

			if(plotResponse == 1)
					h = figure('Name','Filter responses');
					s1 = subplot(1,2,1);
					plot(k,x,'-ko')
					hold on; grid on
					plot(s1,0:M,x)
					xlabel('samples');
					ylabel('Filter coefficient value');
					legend('acausal impulse response','causal impulse response')
					s2 = subplot(1,2,2);
					[H1,W1] = freqz(b,a,1000);
					[H,W] = freqz(bh,a,1000);
					plot(s2,W*fs/(2*pi),abs((H)));hold on; grid on
					plot(s2,W1*fs/(2*pi),abs(H1))
					xlabel('frequency [Hz]');
					ylabel('Amplitude |H(e^{j\Omega})|');
					legend('hann-windowed frequency response','unwindowed frequency response')
					set(h,'Position',[972   568   927   420]);
			end
	else
			error('Number of coefficients around zero need to be even!')
	end
end

