function [] = writeToDtwKnnResultsFile(fileName, outputFileContent)
    
    fid = fopen(fileName, 'a');
    fprintf(fid, "Distance metric: %s ", outputFileContent.metric);
    fprintf(fid, "== Validation errors: ==\n");
    for k = 1:outputFileContent.kMax
        for foldIndex = 1:outputFileContent.numFolds
            fprintf(fid, "%1.4f, ", outputFileContent.validationErrorsOverFolds(k,foldIndex));
        end
        fprintf(fid, "\n");
    end
    kOptOverFolds = outputFileContent.kOptOverFolds;
    fprintf(fid, "kOpt = {");
    for(k = 1:outputFileContent.kMax)
        fprintf(fid, " %d", kOptOverFolds(k));
    end
    fprintf(fid, "}\n");
    fprintf(fid, sprintf("Test error for kOpt=%d: %1.4f\n", ...
            outputFileContent.kOpt, outputFileContent.testError));
    fclose(fid);    
end

