function [predictedClasses] = classifyKnn(Xdatabase, Ydatabase, Xtest, k, metric)
% Calculate the k-nearest neighbor classification result between
% a set of known (database) sequences and a set of test (new) sequences
% Inputs:
%   k: k-nearest neighbors
%   Xdatabase: known sequences
%   Ydatabase: known sequence labels
%   Xtest: test sequences

    numDbSeqs = numel(Xdatabase);
    numTestSeqs = numel(Xtest);
    cost = inf(numDbSeqs, 1);
    % allocate vectors for predictions:
    predictedClasses = categorical(zeros(numTestSeqs,1));

    for testSeqIndex = 1:numTestSeqs
       % calculate DTW between current validation seq and every training seq:
       for(dbSeqIndex = 1:numDbSeqs)
           cost(dbSeqIndex) = dtw(Xtest{testSeqIndex}, Xdatabase{dbSeqIndex}, ...
                                     metric);
       end
       [~, sortedCostIndices] = sort(cost);
       kClassPredictions = Ydatabase(sortedCostIndices(1:k));
       predictedClasses(testSeqIndex) = mode(kClassPredictions);
    end
    
end

