import matplotlib.pyplot as plt
import pandas as pd

# Here type the path to the supplemental materials
file_path = ""

# Choose here the phoneme to be plotted by uncommenting the desired phoneme
phoneme = "b"
# phoneme = "d"
# phoneme = "g"
# phoneme = "v"
# phoneme = "z"
# phoneme = "z_postalveolar"
# phoneme = "p"
# phoneme = "t"
# phoneme = "k"
# phoneme = "f"
# phoneme = "s"
# phoneme = "s_postalveolar"

# Choose here the repetition of the phoneme to be plotted by uncommenting the desired repetition
repetition = "1"
# repetition = "2"
# repetition = "3"
# repetition = "4"
# repetition = "5"

glottal_area_waveform_parameters_df = pd.read_csv(file_path + phoneme + "_repetition" + repetition + ".csv")

# Plotting the parameters along with the glottal area itself
fig, axs = plt.subplots()

axs.set_xlabel("Time [Samples @ 20 kHz]")
axs.set_ylabel(r"Glottal area [pixels], ACA [pixels], DCA [pixels], $f_0$ [Hz]")
axs.plot(glottal_area_waveform_parameters_df['Glottal area'], label='Glottal area')
axs.plot(glottal_area_waveform_parameters_df['F0'], label='f0')
axs.plot(glottal_area_waveform_parameters_df['ACA'], label='ACA')
axs.plot(glottal_area_waveform_parameters_df['DCA'], label='DCA')
axs.legend(loc='upper left')
axs.set_title(f"Glottal area waveform and its parameters for the phoneme {phoneme}, repetition {repetition}.")

axs2 = axs.twinx()

axs2.set_ylabel(r"Open Quotient [no unit]")
axs2.plot(glottal_area_waveform_parameters_df['Open Quotient'], color='black', label='OQ')
axs2.legend(loc='upper right')
axs2.set_ylim(bottom=0, top=1)

plt.grid()
plt.draw()
plt.show()
