clear all


groupes_names = {'with_lips',...
    'without_lips', ...
    'with_torso_without_lips',...
    'without_torso_without_lips',...
    'vowel_a_with_lips',...
    'vowel_i_with_lips',...
    'vowel_u_with_lips',...
    'male_with_lips',...
    'female_with_lips'};
nb_groupes = length(groupes_names);

files_groupes_to_average = {...
    {'s1-a-with-lip.mat',...                % with lips
    's1-i-with-lip.mat', ...
    's1-u-with-lip.mat', ...
    's2-a-with-lip.mat', ...
    's2-i-with-lip.mat', ...
    's2-u-with-lip.mat'} ...
    {'s1-a-without-lip.mat',...             % without lips
    's1-i-without-lip.mat', ...
    's1-u-without-lip.mat', ...
    's2-a-without-lip.mat',...
    's2-i-without-lip.mat',...
    's2-u-without-lip.mat'}...
    {'s1-a-without-lip.mat',...             % torso, no lips
    's2-a-without-lip.mat'}....
    {'s1-a-without-lip-head-alone.mat',...  % no torso, no lips
    's2-a-without-lip-head-alone.mat'}...
    {'s1-a-with-lip.mat',...                % /a/ with lips
    's2-a-with-lip.mat'}...
    {'s1-i-with-lip.mat',...                % /i/ with lips
    's2-i-with-lip.mat'}...
    {'s1-u-with-lip.mat',...                % /u/ with lips
    's2-u-with-lip.mat'}...
    {'s1-a-with-lip.mat',...                % male with lips
    's1-i-with-lip.mat',...
    's1-u-with-lip.mat'}...
    {'s2-a-with-lip.mat',...                % female with lips
    's2-i-with-lip.mat',...
    's2-u-with-lip.mat'}...
    };

data_directory = 'directivity_data/';
average_data_directory = 'averaged_directivity_data';
if exist(average_data_directory, 'dir') == 0
    mkdir([pwd '/' average_data_directory])
end

correct_anomalies =                 true;
spectral_smoothing =                true;
remove_data_below_bckgd_noise =     false;
normalize =                         false;

% minimal percentage of the area measured required to consider the  
% data as valid (0 take all, 100 take only if all the surface is covered)
min_perc_area = 0;

nPol = 12;
nAzi = 24;
nbFreqs = 3414;

for g = 1:nb_groupes
    
    fprintf('\nAveraging data %s ...\n', groupes_names{g});
    
    nb_files = length(files_groupes_to_average{g});
    
    amp = zeros(nPol, nAzi, nbFreqs, nb_files);
    noise = zeros(nPol, nbFreqs, nb_files);
    
    for fi = 1:nb_files
        
        file_name = files_groupes_to_average{g}{fi};
        fprintf('Processing file %s ...\n', file_name);
        
        % load data
        load([data_directory file_name]);
        
        if correct_anomalies
            data = correct_data(data, file_name);
        end
        
        data = preprocess_data(data, spectral_smoothing, ...
    remove_data_below_bckgd_noise, normalize, min_perc_area);
        
        % concatenate the data of all the files
        amp(:,:,:,fi) = db2mag(data.amplitude);
        noise(:,:,fi) = db2mag(data.bckgdNoise);
        
    end
    
    % average the data
    data.amplitude = mag2db(mean(amp, 4, 'omitnan'));
    data.bckgdNoise = mag2db(mean(noise, 3, 'omitnan'));
    
    % save data
    save([average_data_directory '/' groupes_names{g} '_average.mat'], 'data')
end