function [data] = correct_data(data, file_name)
switch file_name
    case 's1-a-with-lip.mat'
        
        % smooth the background noise
        smoothed_bckgd_noise  = smoothdata(data.bckgdNoise, 2, 'gaussian',125);
        
        idx_pol_120 = find(data.polarAngles == 120);
        idx_azi_m180 = find(data.azimuthalAngles == -180);
        under_backgd_noise = squeeze(data.amplitude(idx_pol_120, idx_azi_m180, :))' ...
            < smoothed_bckgd_noise(idx_pol_120, :) + 8;
        data.amplitude(idx_pol_120, idx_azi_m180, under_backgd_noise) = ...
        smoothed_bckgd_noise(idx_pol_120, under_backgd_noise) - 10;
        
        
    case 's1-a-without-lip.mat'
        az_to_remove = [-90, -75, -60];
        pol_to_remove = 120;
        
        % identify the index of the positions to remove
        idx_az_to_remove = zeros(size(az_to_remove));
        idx_pol_to_remove = zeros(size(pol_to_remove));
        for ii = 1:length(az_to_remove)
            idx_az_to_remove(ii) = find(data.azimuthalAngles == az_to_remove(ii));
        end
        for ii = 1:length(pol_to_remove)
            idx_pol_to_remove(ii) = find(data.polarAngles == pol_to_remove(ii));
        end
        
        % replace invalid data by NAN
        data.amplitude(idx_pol_to_remove, idx_az_to_remove, :) = nan;
        
    case 's1-a-without-lip-head-alone.mat'
        
        % remove the data below the unusually high background noise at
        % pol = 105 deg
        bckgd_noise_profile = linspace(-37.5 + 10, -31 + 10, data.nbFreqs)';
        idx_pol_to_correct = 8;
        idx_az_to_correct = [1:5 12:24];
        for ii = 1:length(idx_az_to_correct)
            below_noise = squeeze(data.amplitude(idx_pol_to_correct, idx_az_to_correct(ii), :)) ...
                < bckgd_noise_profile;
            data.amplitude(idx_pol_to_correct, idx_az_to_correct(ii), below_noise) = ...
                data.bckgdNoise(idx_pol_to_correct, below_noise) - 5;
        end
        
        % substiture the data with unusually high backgrounf noise at 
        % pol = 0 deg and az = -105, -120 deg with the neighboring data
        idx_pol_to_correct = 1;
        idx_az_to_correct = [5 6];
        data.amplitude(idx_pol_to_correct, idx_az_to_correct(1), :) = ...
            data.amplitude(idx_pol_to_correct, idx_az_to_correct(1) - 1, :);
        data.amplitude(idx_pol_to_correct, idx_az_to_correct(2), :) = ...
            data.amplitude(idx_pol_to_correct, idx_az_to_correct(2) + 1, :);
        
    case 's2-a-without-lip-head-alone.mat'
        
        idx90 = find(data.polarAngles == 90);
        nAzi = length(data.azimuthalAngles);
        tmpAmp = zeros(nAzi, data.nbFreqs);
        tmpAmp(1:nAzi-1, :) = squeeze(data.amplitude(idx90, 2:end, :));
        tmpAmp(end, :) = squeeze(data.amplitude(idx90, 1, :));
        data.amplitude(idx90, :, :) = tmpAmp;
            
    case 's1-u-without-lip.mat'
        
        % smooth the background noise
        smoothed_bckgd_noise  = smoothdata(data.bckgdNoise, 2, 'gaussian',125);
        
        idx_pol_150 = find(data.polarAngles == 150);
        idx_azi_105 = find(data.azimuthalAngles == 105);
        under_backgd_noise = squeeze(data.amplitude(idx_pol_150, idx_azi_105, :))' ...
            < smoothed_bckgd_noise(idx_pol_150, :) + 9;
        data.amplitude(idx_pol_150, idx_azi_105, under_backgd_noise) = ...
        smoothed_bckgd_noise(idx_pol_150, under_backgd_noise) - 10;
    
        idx_pol_165 = find(data.polarAngles == 165);
        idx_azi_m150 = find(data.azimuthalAngles == -150);
        under_backgd_noise = squeeze(data.amplitude(idx_pol_165, idx_azi_m150, :))' ...
            < smoothed_bckgd_noise(idx_pol_165, :) + 6;
        data.amplitude(idx_pol_165, idx_azi_m150, under_backgd_noise) = ...
            smoothed_bckgd_noise(idx_pol_165, under_backgd_noise) - 10;
end
end
