# Efficient super-wide bandwidth extension (SWBE) using linear prediction based analysis synthesis (LPAS)

# Description:
- This folder contains MATLAB scripts to perform super-wide bandwidth extension (SWBE) using linear prediction based analysis-synthesis.
____________________________________________________________________________

Copyright (C) 2018 EURECOM, France.

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International
License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/4.0/
____________________________________________________________________________

For further details refer to following publication:
- [P. Bachhav, M. Todisco, and N. Evans, “Efficient super-wide bandwidth extension using linear prediction based analysis synthesis,” in Proc. of IEEE Int. Conf. on Acoustics, Speech and Signal Processing (ICASSP), 2018, pp. 5429-5433, Calgary, Canada.](http://www.eurecom.fr/fr/publication/5502/download/sec-publi-5502.pdf)
____________________________________________________________________________

# Usage:

- Run script Demo.m 
	- This script demonstrates the comparison of SWBE using our proposed approach, the baseline and speech processed with enhanced voice services (EVS) codec
	- Function SWBE_LPAS.m performs SWBE using the proposed approach.
	- Function SWBE_EHBE.m performs SWBE using the baseline 
	         (For further details realted to the baseline refer to : E. Larsen, R. M. Aarts, and M. Danessis, “Efficient highfrequency bandwidth extension of music and speech,” in Audio Engineering Society Convention 112. Audio Engineering Society, 2002.)

____________________________________________________________________________
   
# Contact information

For any query, please contact:

- Pramod Bachhav (bachhav at eurecom dot fr)
- Massimiliano Todisco (todisco at eurecom dot fr)
- Nicholas Evans (evans at eurecom dot fr)

____________________________________________________________________________
