# Artificial Bandwidth Extension (ABE)

# Description:

This package contains scripts to perform artificial bandwidth extension (ABE), super-wide bandwidth extension (SWBE) and some useful functions
____________________________________________________________________________
Copyright (C) 2018 EURECOM, France.
This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/4.0/
____________________________________________________________________________
# Contents:
1.  ABE_explicit_memory_ICASSP18
    * This package contains scripts to perform ABE using explicit memory inclusion approach presented in the following publication:
[P. Bachhav, M. Todisco, and N. Evans, “Exploiting explicit memory inclusion for artificial bandwidth extension,” in Proc. of IEEE Int. Conf. on Acoustics, Speech and Signal Processing (ICASSP), 2018, pp. 5459-63, Calgary, Canada.](http://www.eurecom.fr/fr/publication/5501/download/sec-publi-5501.pdf)
    * Refer "Readme.txt" in folder "ABE_explicit_memory_ICASSP18" for further details

2. SWBE_LPAS_ICASSP18
    * This package contains scripts to perform SWBE using linear prediction based analysis-synthesis approach presented in the following publication:
[P. Bachhav, M. Todisco, and N. Evans, “Efficient super-wide bandwidth extension using linear prediction based analysis synthesis,” in Proc. of IEEE Int. Conf. on Acoustics, Speech and Signal Processing (ICASSP), 2018, pp. 5429-5433, Calgary, Canada.](http://www.eurecom.fr/fr/publication/5502/download/sec-publi-5502.pdf)
    * Refer "Readme.txt" in folder "SWBE_LPAS_ICASSP18" for further details

3. ABE_SSAE_IS18
    * This package contains scripts to perform ABE with memory inclusion using Semi-supervised Stacked Auto-encoders approach presented in the following publication:
[P. Bachhav, M. Todisco, and N. Evans, "Artificial Bandwidth Extension with Memory Inclusion using Semi-supervised Stacked Auto-encoders", in Proc. of INTERSPEECH, pp. 1185-89, Hyderabad, India.](http://www.eurecom.fr/fr/publication/5592/download/sec-publi-5592.pdf)
    * Refer "Readme.txt" in folder "ABE_SSAE_IS18" for further details
    
4. ABE_CVAE_ICASSP19
    * This package contains scripts to perform ABE with latent features obtained using a deep generative model based approach presented in the following publication:
[P. Bachhav, M. Todisco, and N. Evans, "Latent Representation Learning for Artificial  Bandwidth Extension using a Conditional Variational Auto-Encoder", accepted in ICASSP 2019. ](http://www.eurecom.fr/fr/publication/5817/download/sec-publi-5817.pdf)
    * Refer "Readme.txt" in folder "ABE_CVAE_ICASSP19" for further details
	
5. utilities
    * This folder contains MATLAB scripts or functions used for ABE and SWBE tasks listed above
    
6. Filters
    * This folder contains impulse response of FIR filters used

7. Examples
    * This folder contains usage examples of some functions available in folder "utilities"

____________________________________________________________________________

All the scripts are successfully tested on MATLAB 2018a
____________________________________________________________________________

# Contact information
For any query, please contact:
* Pramod Bachhav (bachhav at eurecom dot fr)
* Massimiliano Todisco (todisco at eurecom dot fr)
* Nicholas Evans (evans at eurecom dot fr)
____________________________________________________________________________

