function vocalTractGoemetry = getVocalTractGeometry(vocalTractGoemetryFile, maxWidth)

% get the text
txt = fileread(vocalTractGoemetryFile);
txt = strsplit(txt,'\n');

nSlices = 129;
nz = 96;
centerLinePoints = zeros(nSlices,2);
centerLineNormals = zeros(nSlices,2);
upperProfile = zeros(nSlices,nz);
lowerProfile = zeros(nSlices,nz);
cnt = 0;

for s = 6:4:length(txt)-1
    cnt = cnt +1;
    
    % center line points
    txt3 = strsplit(txt{s},' ');
    centerLinePoints(cnt, 1) = str2double(txt3{1});
    centerLinePoints(cnt, 2) = str2double(txt3{2});
    
    % center line normals
    txt3 = strsplit(txt{s+1},' ');
    centerLineNormals(cnt, 1) = str2double(txt3{1});
    centerLineNormals(cnt, 2) = str2double(txt3{2});
    
    % upper profile
    txt3 = strsplit(txt{s+2},' ');
    for p = 1:96
        upperProfile(cnt, p) = str2double(txt3{p});
    end
    
    % lower profile
    txt3 = strsplit(txt{s+3},' ');
    for p = 1:96
        lowerProfile(cnt, p) = str2double(txt3{p});
    end
end


% compute area function
dz = maxWidth/(nz-1);
A = zeros(1, nSlices);
for s = 1:nSlices
    realUpperProfile = upperProfile(s,upperProfile(s,:)<100);
    realLowerProfile = lowerProfile(s,lowerProfile(s,:)<100);
    u1 = realUpperProfile(1:end-1);
    u2 = realUpperProfile(2:end);
    l1 = realLowerProfile(1:end-1);
    l2 = realLowerProfile(2:end);
    A(s) = sum(dz*(abs(u2-u1) + min(u1-l1,u2-l2) + abs(l2-l1)));
end

vocalTractGoemetry = struct("centerLinePoints", centerLinePoints, ...
"centerLineNormals", centerLineNormals, ...
"upperProfile", upperProfile, ...
"lowerProfile", lowerProfile, ...
"areaFunction", A);

end