geometryFile = 'vowel-@-female.txt';
maxWidth = 5.5;
vocalTractGeometry = getVocalTractGeometry(geometryFile, maxWidth);

%% plot geometry
nSLices = length(vocalTractGeometry.areaFunction);
nz = length(vocalTractGeometry.upperProfile(1,:));
z = linspace(-maxWidth/2, maxWidth/2, nz);

figure
hold on
for s = 1: nSLices
    % plot upper profile
    x = vocalTractGeometry.centerLinePoints(s,1)*ones(1,nz) + ...
        vocalTractGeometry.upperProfile(s,:)*vocalTractGeometry.centerLineNormals(s,1);
    y = vocalTractGeometry.upperProfile(s,:)*vocalTractGeometry.centerLineNormals(s,2) ...
        + vocalTractGeometry.centerLinePoints(s,2);
    realPoints = vocalTractGeometry.upperProfile(s,:) < 100;
    plot3(x(realPoints), y(realPoints), z(realPoints), 'k')
    
    % plot lower profile
    x = vocalTractGeometry.centerLinePoints(s,1)*ones(1,nz) + ...
        vocalTractGeometry.lowerProfile(s,:)*vocalTractGeometry.centerLineNormals(s,1);
    y = vocalTractGeometry.lowerProfile(s,:)*vocalTractGeometry.centerLineNormals(s,2) ...
        + vocalTractGeometry.centerLinePoints(s,2);
    plot3(x(realPoints), y(realPoints), z(realPoints), 'k')
end