
@echo off
set "batchpath=%cd%"
set /p session=enter Session name:
::generate folder structure
md capture
cd capture
md raw %session%_processed
cd %session%_processed
md front side
cd..
cd..
CLS

@echo off & setlocal enabledelayedexpansion 
@echo --------------------------------------------------------------
@echo Image Processing in VirtualDub

@echo creating VirtualDub Scripts

set "InputScript=%batchpath%\Skripte_VDub\front_processing.vdscript" 
set "OutputScript=%batchpath%\front_processing.vdscript" 
set "Von1=--Dateipfad_In--" 
set "Nach1=%batchpath%\capture\raw\%session%_front.avi" 
set "Von2=--Dateipfad_Out--" 
set "Nach2=%batchpath%\capture\%session%_processed\front\%session%_front.avi"
 
set "t=%temp%\text.tmp" 
if exist "%t%" del "%t%" 
for /f "delims=" %%i in ('findstr /n $ "%InputScript%"') do set "Line=%%i" & call :ProcessLine1 
move "%t%" "%OutputScript%" 
goto CONTINUE2
 
:ProcessLine1 
for /f "tokens=1* delims=:" %%a in ("%Line%") do set "L=%%b" 
if not defined L >>"%t%" echo\& goto :eof
set WriteLine1=!L:%Von1%=%Nach1%! 
set WriteLine2=!WriteLine1:%Von2%=%Nach2%! 
>>"%t%" echo !WriteLine2! 
goto :eof

:CONTINUE2

@echo off & setlocal enabledelayedexpansion 
set "InputScript=%batchpath%\Skripte_VDub\side_processing.vdscript" 
set "OutputScript=%batchpath%\side_processing.vdscript" 
set "Von1=--Dateipfad_In--" 
set "Nach1=%batchpath%\capture\raw\%session%_side.avi" 
set "Von2=--Dateipfad_Out--" 
set "Nach2=%batchpath%\capture\%session%_processed\side\%session%_side.avi"
 
set "t=%temp%\text.tmp" 
if exist "%t%" del "%t%" 
for /f "delims=" %%i in ('findstr /n $ "%InputScript%"') do set "Line=%%i" & call :ProcessLine2 
move "%t%" "%OutputScript%" 
goto CONTINUE3
 
:ProcessLine2 
for /f "tokens=1* delims=:" %%a in ("%Line%") do set "L=%%b" 
if not defined L >>"%t%" echo\& goto :eof
set WriteLine1=!L:%Von1%=%Nach1%! 
set WriteLine2=!WriteLine1:%Von2%=%Nach2%! 
>>"%t%" echo !WriteLine2! 
goto :eof

:CONTINUE3

Start "" "Veedub64" /s "%batchpath%\front_processing.vdscript" /x
Start "" "Veedub64" /s "%batchpath%\side_processing.vdscript" /x

@echo --------------------------------------------------------------
@echo waiting for image processing to finish

:LOOP4
TASKLIST | FIND /I "Veedub64.exe" >nul
IF ERRORLEVEL 1 (
  GOTO CONTINUE4
) ELSE (
  GOTO LOOP4
)
:CONTINUE4

del "%batchpath%\front_processing.vdscript"
del "%batchpath%\side_processing.vdscript"

CLS
@echo image processing finished
@echo --------------------------------------------------------------
@echo Folders with the image sequences will open
@echo Please delete every Image before the synchronisation event!!!
@echo press any key to continue

PAUSE >nul
PAUSE >nul

Explorer %batchpath%\capture\%session%_processed\front
Explorer %batchpath%\capture\%session%_processed\side

CLS
@echo --------------------------------------------------------------
@echo Images deleted????
@echo press any key to continue

PAUSE >nul
PAUSE >nul

CLS
@echo --------------------------------------------------------------
@echo GIE will start
@echo _
@echo In GIE please load the captured image sequences at the directories: 
@echo %batchpath%\capture\%session%_processed\front
@echo and:
@echo %batchpath%\capture\%session%_processed\side
@echo _
@echo please segment front and profile view and store the contours at the path:
@echo %batchpath%\capture\%session%_processed\
@echo named:
@echo %session%_front_contour.txt
@echo %session%_side_contour.txt
@echo then close GIE
@echo press any key to continue

PAUSE >nul
PAUSE >nul


Start "" "GlottalImageExplorer"
@echo --------------------------------------------------------------
@echo waiting for segmentation

:LOOP5
TASKLIST | FIND /I "GlottalImageExplorer.exe" >nul
IF ERRORLEVEL 1 (
  GOTO CONTINUE5
) ELSE (
  GOTO LOOP5
)
:CONTINUE5

CLS
@echo --------------------------------------------------------------
@echo processing lip cotours and calculatin lip parameters
@echo this can take up to 5 minutes

cd capture\%session%_processed\

octave %batchpath%\Skripte_Matlab\calc_lip_parameters.m %session%_front_contour.txt %session%_side_contour.txt %session%_lip_parameter.txt


@echo --------------------------------------------------------------
@echo end of calculations
@echo you can find the timeseries of the lip parameters here:
@echo %batchpath%\capture\%session%_processed\%session%_lip_parameter.txt
@echo press any key to exit
PAUSE >nul
PAUSE >nul
@echo end

