#! /usr/bin/octave -qf

# calculation of lip parameters
clear

%load input argumets
arglist = argv();
frontfile = arglist{1};%'001training_front_contour.txt';%
sidefile = arglist{2};%'001training_side_contour.txt';%
outfile = arglist{3};%'001training_lip_parameter.txt';%

%load signal pakage
pkg load signal
%----------------------------------------------
%optional, plot every "every" contour
print = true;
every = 100;
%max allowed deviation of the found maximum in the profile contour 
maxdev = 40;
deltamaxsearch = 10; %search radius for the replacement maximum

%----------------------------------------------
%load txt Files
%side
in = fopen(sidefile,'r');
heads = fgetl(in);
Sin = fscanf(in, '%u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u', [256 Inf]);
fclose(in);
%delete every secont line, only left contour is of interest
n = 1;
while n<=(columns(Sin))
  m = ((n+1)/2);
  S(:,m)=Sin(:,n);
  n+=2;
end

%front
in = fopen(frontfile,'r');
headf = fgetl(in);
Fc = fscanf(in, '%u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u', [256 Inf]);
fclose(in);
Fc(Fc==0)=NaN; %replace zero by NaN

%-------------------------------------------------

%side processing
%find peaks in side contour
for n=1:(columns(S))
  x = linspace(1,256,256);
  y = [S(x,n)];
  [pks,locsmax] = findpeaks(y,'MinPeakWidth',40,'MinPeakDistance',40);
  if(rows(pks)>0)
    if ((locsmax(1,1)>40)||rows(pks)<3)
      P(n,1)=pks(1,1);
      P(n,2)=locsmax(1,1);
      if (rows(pks)<2)
        P(n,3)=P(n-1,3);
        P(n,4)=P(n-1,4);
      else
        P(n,3)=pks(2,1);
        P(n,4)=locsmax(2,1);
      endif
    else
      P(n,1)=pks(2,1);
      P(n,2)=locsmax(2,1);
      P(n,3)=pks(3,1);
      P(n,4)=locsmax(3,1);
    endif
  else
    P(n,1)=255;
    P(n,2)=255;
  endif

end

%find miscalculated extrema
midi=int16(mean(P));
meanlocmax=midi(1,2);
Pn=P;
for n=1:rows(P)
  if ((abs(P(n,2)-meanlocmax))>maxdev)
    [Pn(n,1),Pn(n,2)]=max(S((meanlocmax-deltamaxsearch):(meanlocmax+deltamaxsearch),n));
    Pn(n,2)+=(meanlocmax-deltamaxsearch);
  end
end



%plot protrusion timeseries
x = linspace(1,rows(P),rows(P));
y = [Pn(x,1)];    %Peak1
figure(1);
subplot(2,1,2);
plot(x,y)%,x,y2,'g',x,y3,'m',x,y4,'c')

%plot every "every" contour
for n=1:rows(Pn)
  if (print&&mod(n,every)==0); %mod(n,1000)==0
    x = linspace(1,256,256);
    y = [S(x,n)];
    figure(n)
    subplot(1,2,1)
    plot(x,y,Pn(n,2),Pn(n,1),'.m')
    xlim([1,256])
    ylim([1,256])
  end
end

%---------------------------------------------


 %calculate opening
for n=1:(columns(Fc)/2);
  x = linspace(1,256,256);
  upperlip = [Fc(x,(2*n))];
  lowerlip = [Fc(x,(2*n)-1)];
  [dump,leftcorner] = max(diff(~isnan(upperlip)));
  [dump,rightcorner] = min(diff(~isnan(upperlip)));
  if (rightcorner-leftcorner<=0)
    O(n,1)=0;
  else
    maximum = (upperlip(int16((rightcorner-leftcorner)/2)+leftcorner,1));
    minimum = (lowerlip(int16((rightcorner-leftcorner)/2)+leftcorner,1));
    O(n,1) = maximum-minimum; %vertikal opening
    O(n,2) = rightcorner-leftcorner; %horizontal opening
    %plot every "every" front contour
    if ((print&&mod(n,every)==0));
      figure(n)
      subplot(1,2,2)
      plot(x,lowerlip,x,upperlip,x,maximum,'.g',x,minimum,'.m')
      xlim([-1,256])
      ylim([-1,256])
    end
  end

end

rowsmax=min(rows(Pn),rows(O)); %Länge von Front- und Seitenvektor  gleich machen
Pn([rowsmax:rows(Pn)],:)=[];  %-"-
O([rowsmax:rows(O)],:)=[];    %-"-
OUT(1,:) = Pn(:,1);
OUT(2,:) = O(:,1);
output=fopen(outfile,'w');
fprintf(output,'#protrusion and opening, one line per frame\n');
fprintf(output,'%f %f \n', OUT);
fclose(output);