// ****************************************************************************
// This file is part of VocalTractLab.
// Copyright (C) 2025, Peter Birkholz, Dresden, Germany
// www.vocaltractlab.de
// author: Peter Birkholz
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef __PHYSICAL_CONSTANTS_H__
#define __PHYSICAL_CONSTANTS_H__

// ****************************************************************************
// Physical constants according to Flanagan (1965).
// ****************************************************************************

const double STATIC_PRESSURE_CGS = 1.013e6;   // deci-Pa = ubar
const double AMBIENT_DENSITY_CGS = 1.14e-3;   // g/cm^3
const double ADIABATIC_CONSTANT = 1.4;      
const double SOUND_VELOCITY_CGS = 3.5e4;      // cm/s
const double AIR_VISCOSITY_CGS = 1.86e-4;     // dyne-s/cm^2
const double SPECIFIC_HEAT_CGS = 0.24;        // cal/g-K
const double HEAT_CONDUCTION_CGS = 0.055e-3;  // cal/cm-s-K

// ****************************************************************************
// Properties of the vocal tract walls. As long as the values are not constant
// (for testing different settings), we must declare the variables here as
// "extern", and the definition (initial value assignment) must be made in the 
// separate Constants.cpp file.
// Later they will be turned into real constants.
// ****************************************************************************

extern double WALL_MASS_PER_UNIT_AREA_CGS;
extern double WALL_DAMPING_PER_UNIT_AREA_CGS;
extern double WALL_STIFFNESS_PER_UNIT_AREA_CGS;

// ****************************************************************************
// These constants are needed for the model for viscous and kinetic losses both
// in the FDS and the TDS.
// ****************************************************************************

const double REF_AREA_CM2 = 1.0;
const double DC_R0 = 0.03;
const double DC_EXPONENT = 2.6;
const double AC_R0 = 0.0065;
const double AC_EXPONENT = 1.0;
const double AC_FREQUENCY_HZ = 2250.0;
const double GLOTTIS_RECOVERY_COEFF = 0.2;
const double TRACT_RECOVERY_COEFF = 0.5;

// ****************************************************************************
// Constants for the synthesis.
// ****************************************************************************

const int AUDIO_SAMPLING_RATE_HZ = 48000;
const double SYNTHETIC_SPEECH_BANDWIDTH_HZ = 12000.0;

// FIR filter for the piston-in-sphere radiation characteristic (for 48 kHz).

const int NUM_PISTON_SPHERE_RADIATION_FILTER_SAMPLES = 64;
const double PISTON_SPHERE_RADIATION_FILTER[NUM_PISTON_SPHERE_RADIATION_FILTER_SAMPLES] =
{
  -0.00199472310250685, 0.000450900108377389, -0.000802410847550565, 0.000517865017353882,
  -0.000939459049381588, 0.000583351668298113, -0.00108754809040553, 0.000686815022106375,
  -0.00130225401246549, 0.000793207047905541, -0.00154492255873007, 0.000966506760690126,
  -0.00190644123342826, 0.00115994467288478, -0.00234149812623974, 0.00148660896464732,
  -0.00301813882527687, 0.00189741078733049, -0.00390999864950643, 0.0026353299894599,
  -0.0054092229786154, 0.00374040778170073, -0.00770003725285869, 0.00600461687219247,
  -0.0122343909366787, 0.0105593618922881, -0.0216169307613804, 0.0238146056061373,
  -0.0514885741843423, 0.0823014318906213, -0.256105195995944, 2.23689721836029,
  -2.23689721836029, 0.256105195995944, -0.0823014318906213, 0.0514885741843423,
  -0.0238146056061373, 0.0216169307613804, -0.0105593618922881, 0.0122343909366787,
  -0.00600461687219247, 0.00770003725285869, -0.00374040778170073, 0.0054092229786154,
  -0.0026353299894599, 0.00390999864950643, -0.00189741078733049, 0.00301813882527687,
  -0.00148660896464732, 0.00234149812623974, -0.00115994467288478, 0.00190644123342826,
  -0.000966506760690126, 0.00154492255873007, -0.000793207047905541, 0.00130225401246549,
  -0.000686815022106375, 0.00108754809040553, -0.000583351668298113, 0.000939459049381588,
  -0.000517865017353882, 0.000802410847550565, -0.000450900108377389, 0.00199472310250685
};

// FIR filter for the radiation characteristic based on an FEM head-torso model (for 48 kHz).

const int NUM_HEAD_TORSO_RADIATION_FILTER_SAMPLES = 180;
const double HEAD_TORSO_RADIATION_FILTER[NUM_HEAD_TORSO_RADIATION_FILTER_SAMPLES] =
{
  0.00147529910983571, 0.00216786555081796, 0.00181358071943911, -0.000305643576695614,
  -0.00250912421551869, -0.00265381788400364, -0.00144875242587603, 0.000189399235271662,
  0.000900097668262156, 0.00124270316317065, 0.00103703974878458, 0.000824581248809237,
  6.85464632672159e-05, -0.000397073917112339, -0.000768324059588227, -0.000503870213334211,
  -0.000501784780122153, -0.000269203504738122, -0.00023011927997909, 0.000263743593507072,
  0.000136130345275783, -0.000353755860881524, -0.00166437749957094, -0.00223030284090778,
  -0.00200100653376215, -0.000249562438260815, 0.00124473975271324, 0.00194799908826153,
  0.000521796315329886, -0.00118844162294877, -0.00235230252899102, -0.0013333534350717,
  -2.83664376434139e-05, 0.00116440070020853, 0.000961491901274461, 0.001016969367802,
  0.00045323967271822, 0.000138004419924926, -0.000742115357147377, -0.000145249302959242,
  0.000294628270585573, 0.000220062216743392, -0.00201896318792434, -0.00238854884871902,
  -0.000127190058621055,0.00413054246777836,0.00414602873874739,0.0012094946918349,
  -0.00133658098634161,0.00143989791277996,0.00276882629413218,-0.00149213826739942,
  -0.00974411522826889,-0.0075539865756404,0.00713566065506708,0.0239350177426676,
  0.0223201155180611,0.00352698302503351,-0.0179685512393671,-0.0217459511590183,
  -0.0117451727902142,0.00186334669100914,0.00513902694409018,0.00390278452514897,
  -1.70285252103725e-05,0.000798594248533733,-0.000479211313584439,0.000447293106442221,
  -0.00226313199632903,-0.000865360599758553,-0.00296127930974279,-0.00170540135755775,
  -0.00703704595423616,-0.00574453467888181,-0.00378230357909739,0.0117119675264645,
  0.0153049325845585,0.0127282072037897,-0.0112278671743849,-0.0146056299844274,
  -0.0149093409877763,0.0087808639516137,-0.00392921226443044,0.00203050208718944,
  -0.0242239787073441,0.0233524206782919,-0.0149809066311557,0.0851169821703739,
  -0.173439144651108,1.64214508344727,-1.64214508344727,0.173439144651108,
  -0.0851169821703739,0.0149809066311557,-0.0233524206782919,0.0242239787073441,
  -0.00203050208718944,0.00392921226443044,-0.0087808639516137,0.0149093409877763,
  0.0146056299844274,0.0112278671743849,-0.0127282072037897,-0.0153049325845585,
  -0.0117119675264645,0.00378230357909739,0.00574453467888181,0.00703704595423616,
  0.00170540135755775,0.00296127930974279,0.000865360599758553,0.00226313199632903,
  -0.000447293106442221,0.000479211313584439,-0.000798594248533733,1.70285252103725e-05,
  -0.00390278452514897,-0.00513902694409018,-0.00186334669100914,0.0117451727902142,
  0.0217459511590183,0.0179685512393671,-0.00352698302503351,-0.0223201155180611,
  -0.0239350177426676,-0.00713566065506708,0.0075539865756404,0.00974411522826889,
  0.00149213826739942,-0.00276882629413218,-0.00143989791277996,0.00133658098634161,
  -0.0012094946918349,-0.00414602873874739,-0.00413054246777836,0.000127190058621055,
  0.00238854884871902,0.00201896318792434,-0.000220062216743392,-0.000294628270585573,
  0.000145249302959242,0.000742115357147377,-0.000138004419924926,-0.00045323967271822,
  -0.001016969367802,-0.000961491901274461,-0.00116440070020853,2.83664376434139e-05,
  0.0013333534350717,0.00235230252899102,0.00118844162294877,-0.000521796315329886,
  -0.00194799908826153,-0.00124473975271324,0.000249562438260815,0.00200100653376215,
  0.00223030284090778,0.00166437749957094,0.000353755860881524,-0.000136130345275783,
  -0.000263743593507072,0.00023011927997909,0.000269203504738122,0.000501784780122153,
  0.000503870213334211,0.000768324059588227,0.000397073917112339,-6.85464632672159e-05,
  -0.000824581248809237,-0.00103703974878458,-0.00124270316317065,-0.000900097668262156,
  -0.000189399235271662,0.00144875242587603,0.00265381788400364,0.00250912421551869,
  0.000305643576695614,-0.00181358071943911,-0.00216786555081796,-0.00147529910983571
};


#endif

