// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#ifndef __SPECTRUM_PICTURE_H__
#define __SPECTRUM_PICTURE_H__

#include "BasicPicture.h"
#include "Graph.h"
#include "Signal.h"
#include "Data.h"

// ****************************************************************************
// ****************************************************************************

class SpectrumPicture : public BasicPicture
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  // Variables
  Graph graph;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  SpectrumPicture(wxWindow *parent);
  virtual void draw(wxDC &dc);
  void paintContinualSpectrum(wxDC &dc, ComplexSignal *spectrum, double ampFactor, wxColor color, bool showPhase);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  static const wxColor SOURCE_SPECTRUM_COLOR;
  static const wxColor SOURCE_PRODUCT_SPECTRUM_COLOR;
  static const wxColor REFERENCE_RESPONSE_SPECTRUM_COLOR;
  static const wxColor PRIMARY_RESPONSE_SPECTRUM_COLOR;
  static const wxColor FINAL_TRANSFER_FUNCTION_COLOR;

  Data *data;
  wxMenu *contextMenu;
  int menuX, menuY;

  bool showSourceSpectrum;
  bool showInverseSourceSpectrum;
  bool showSourceProductSpectrum;
  bool showReferenceResponseSpectrum;
  bool showPrimaryResponseSpectrum;
  bool showFinalTransferFunction;

  bool showPhase;
  bool showFormants;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void OnMouseEvent(wxMouseEvent &event);

  void OnZoomIn(wxCommandEvent &event);
  void OnZoomOut(wxCommandEvent &event);
  void OnSetAmplitudeRange(wxCommandEvent &event);

  void OnShowSourceSpectrum(wxCommandEvent &event);
  void OnShowInverseSourceSpectrum(wxCommandEvent &event);
  void OnShowSourceProductSpectrum(wxCommandEvent &event);
  void OnShowReferenceResponseSpectrum(wxCommandEvent &event);
  void OnShowPrimaryResponseSpectrum(wxCommandEvent &event);
  void OnShowFinalTransferFunction(wxCommandEvent &event);

  void OnShowPhase(wxCommandEvent &event);
  void OnShowFormants(wxCommandEvent &event);

  // **************************************************************************
  // Declare the event table.
  // **************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif

// ****************************************************************************
