// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#ifndef __SOUND_LIB__
#define __SOUND_LIB__

using namespace std;

#include <vector>
#include <string>

// ****************************************************************************

extern bool enumerateAudioEndpoints(vector<string> &endpointNames, vector<string> &endpointIds, bool outputDevices);
extern bool setAudioEndpointVolume(string endpointId, float volume);
extern int getEndpointIndexFor(string deviceName, vector<string> &endpointNames);

extern void initSound(int SR, int inputDeviceId, int outputDeviceId);
extern void exitSound();
extern bool waveStartPlaying(float *data, int numSamples);
extern bool waveStopPlaying();
extern bool waveStartRecording(float *data, int numSamples);
extern bool waveStopRecording();

// ****************************************************************************

#endif
