// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#include "SilentMessageBox.h"

// ****************************************************************************
/// Constructor.
// ****************************************************************************

SilentMessageBox::SilentMessageBox(const wxString& message, 
  const wxString& caption, wxWindow *parent) : wxDialog(parent, wxID_ANY, 
  caption, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE & ~wxCLOSE_BOX)
{
  // Init the widgets.
  wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

  wxStaticText *labText = new wxStaticText(this, wxID_ANY, message);
  sizer->Add(labText, 0, wxALL, 10);

  wxButton *btnOk = new wxButton(this, wxID_OK, "OK");
  sizer->Add(btnOk, 0, wxALL | wxALIGN_CENTER, 10);

  this->SetSizer(sizer);
  sizer->Fit(this);
  sizer->SetSizeHints(this);
}

// ****************************************************************************
