// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#ifndef __SIGNAL_PICTURE_H__
#define __SIGNAL_PICTURE_H__

#include "BasicPicture.h"
#include "Graph.h"
#include "Data.h"

// ****************************************************************************
// ****************************************************************************

class SignalPicture : public BasicPicture
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  Graph graph;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  SignalPicture(wxWindow *parent);
  virtual void draw(wxDC &dc);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  static const wxColor SOURCE_SIGNAL_COLOR;
  static const wxColor SWEEP_RESPONSE_COLOR[Data::NUM_RESPONSE_SIGNALS];

  Data *data;
  wxMenu *contextMenu;
  int menuX, menuY;
  int lastMx, lastMy;

  bool showSourceSignal;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void paintOscillograms(wxDC &dc);
  void paintOscillogram(wxDC &dc, Signal *s, const wxColor &color);

  void OnMouseEvent(wxMouseEvent &event);

  void OnZoomIn(wxCommandEvent &event);
  void OnZoomOut(wxCommandEvent &event);
  void OnShowSourceSignal(wxCommandEvent &event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif

// ****************************************************************************
