// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#ifndef _MAIN_WINDOW_H_
#define _MAIN_WINDOW_H_

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/spinctrl.h>
#include <wx/radiobox.h>

#include "Data.h"
#include "SoundLib.h"
#include "SignalPicture.h"
#include "ImpulseResponsePicture.h"
#include "SpectrumPicture.h"


// ****************************************************************************
// Main window of the application.
// ****************************************************************************

class MainWindow : public wxFrame
{
  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  MainWindow(wxWindow *parent, wxWindowID id = wxID_ANY, const wxString &title = wxEmptyString);
  
  void initWidgets();
  void updateWidgets();
    
  // ****************************************************************************
  // Private data.
  // **************************************************************************

private:
  wxMenuBar *menuBar;
  Data *data;
  wxFileName exportFileName;
  wxFileName audioFileName;

  // Widgets on the main (right) side.
  SignalPicture *picSignal;
  ImpulseResponsePicture *picImpulseResponse;
  SpectrumPicture *picSpectrum;
  wxScrollBar *scrTime1;      // Time for the source and response signals
  wxScrollBar *scrTime2;      // Time for the impulse response signals

  // Widgets on the control (left) side.
  wxComboBox *lstAudioOutputDevice;
  wxComboBox *lstAudioInputDevice;

  wxTextCtrl *txtFadeInLowerFreq;
  wxTextCtrl *txtFadeInUpperFreq;
  wxTextCtrl *txtFadeOutLowerFreq;
  wxTextCtrl *txtFadeOutUpperFreq;

  wxTextCtrl *txtSourceAmpFactor;

  wxRadioBox *radSignalSelection;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void updateDeviceList();
  void playSignal(Signal *s);

  // The update request is triggered by child windows.
  void OnUpdateRequest(wxCommandEvent &event);

  // Window events

  void OnCloseWindow(wxCloseEvent &event);

  // Menu functions

  void OnTest(wxCommandEvent &event);
  void OnReset(wxCommandEvent &event);
  void OnExit(wxCommandEvent &event);
  void OnAbout(wxCommandEvent &event);

  // Key shortcuts.

  void OnKeyCtrlLeft(wxCommandEvent &event);
  void OnKeyCtrlRight(wxCommandEvent &event);

  // Other callback functions of controls.

  void OnUpdateDeviceLists(wxCommandEvent& event);
  void OnSetDevices(wxCommandEvent& event);

  void OnGenerateSweep(wxCommandEvent& event);
  void OnPlaySourceSignal(wxCommandEvent& event);

  void OnSignalSelection(wxCommandEvent& event);

  void OnRecord(wxCommandEvent& event);
  void OnReplay(wxCommandEvent& event);
  void OnSaveSignal(wxCommandEvent& event);
  void OnLoadSignal(wxCommandEvent& event);
  void OnSaveSpectrum(wxCommandEvent& event);

  void OnCalcFinalTransferFunction(wxCommandEvent& event);
  void OnSaveFinalTransferFunction(wxCommandEvent& event);

  void OnScrollTime1(wxScrollEvent& event);
  void OnScrollTime2(wxScrollEvent& event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif
