// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#ifndef __IMPULSE_RESPONSE_PICTURE_H__
#define __IMPULSE_RESPONSE_PICTURE_H__

#include "BasicPicture.h"
#include "Graph.h"
#include "Data.h"

// ****************************************************************************
// ****************************************************************************

class ImpulseResponsePicture : public BasicPicture
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  Graph graph;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  ImpulseResponsePicture(wxWindow *parent);
  virtual void draw(wxDC &dc);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  static const wxColor IMPULSE_RESPONSE_COLOR[Data::NUM_RESPONSE_SIGNALS];

  Data *data;
  wxMenu *contextMenu;
  int menuX, menuY;
  int lastMx, lastMy;
  bool moveLeftBorder;
  bool moveRightBorder;
  bool showLogWaveform;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void drawSelectionMark(wxDC &dc, int x, int y1, int y2, bool isLeftMark);
  void paintOscillograms(wxDC &dc);
  void paintOscillogram(wxDC &dc, Signal *s, const wxColor &color);
  double getSample(Signal *s, int index);

  void OnMouseEvent(wxMouseEvent &event);

  void OnZoomIn(wxCommandEvent &event);
  void OnZoomOut(wxCommandEvent &event);
  void OnShowLogWaveform(wxCommandEvent &event);

  void OnClearSelection(wxCommandEvent &event);
  void OnSetSelectionStart(wxCommandEvent &event);
  void OnSetSelectionEnd(wxCommandEvent &event);
  void OnSelectAll(wxCommandEvent &event);

  void OnGoToImpulseResponse(wxCommandEvent &event);
  void OnSelectionToSpectrum(wxCommandEvent &event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif

// ****************************************************************************
