// ****************************************************************************
// Copyright(C) 2019 by Peter Birkholz, Dresden, Germany
// This file is part of the program MeasureTransferFunction.
// www.vocaltractlab.de
// ****************************************************************************

#include "Application.h"

#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <iostream>
#include <fstream>

#include "Data.h"

using namespace std;

// ****************************************************************************
// ****************************************************************************

bool Application::OnInit()
{
  createConsole();
  printf("=== Console output for MeasureTransferFunction 1.0 (built %s)===\n\n", __DATE__);

  // Init the data class at the very beginning.
  
  Data *data = Data::getInstance();
  if (argc < 1)
  {
    printf("Error: At least the default command line argument is expected.\n");
  }
  data->init(argv[0]);

  // Create and show the main window.

  MainWindow *mainWindow = new MainWindow(NULL, wxID_ANY, "MeasureTransferFunction");
  mainWindow->SetSize(1200, 800);
  SetTopWindow(mainWindow);
  mainWindow->Show();
  
  return true;
}

// ****************************************************************************
// ****************************************************************************

void Application::createConsole()
{
  // maximum mumber of lines the output console should have
  static const WORD MAX_CONSOLE_LINES = 500;
  int hConHandle;
  HANDLE lStdHandle;

  CONSOLE_SCREEN_BUFFER_INFO coninfo;
  FILE *fp;

  // ****************************************************************

  // allocate a console for this app
  AllocConsole();

  // set the screen buffer to be big enough to let us scroll text
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &coninfo);

  coninfo.dwSize.Y = MAX_CONSOLE_LINES;
  SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE), coninfo.dwSize);
  
  // ****************************************************************
  // redirect unbuffered STDOUT to the console
  // e.g. printf("...", ...);
  // ****************************************************************

  lStdHandle = GetStdHandle(STD_OUTPUT_HANDLE);
  hConHandle = _open_osfhandle((intptr_t)lStdHandle, _O_TEXT);

  fp = _fdopen( hConHandle, "w" );
  *stdout = *fp;
  setvbuf( stdout, NULL, _IONBF, 0 );

  // ****************************************************************
  // redirect unbuffered STDIN to the console
  // ****************************************************************

  lStdHandle = GetStdHandle(STD_INPUT_HANDLE);
  hConHandle = _open_osfhandle((intptr_t)lStdHandle, _O_TEXT);

  fp = _fdopen( hConHandle, "r" );
  *stdin = *fp;
  setvbuf( stdin, NULL, _IONBF, 0 );

  // ****************************************************************
  // redirect unbuffered STDERR to the console
  // ****************************************************************

  lStdHandle = GetStdHandle(STD_ERROR_HANDLE);
  hConHandle = _open_osfhandle((intptr_t)lStdHandle, _O_TEXT);
  fp = _fdopen( hConHandle, "w" );
  *stderr = *fp;
  setvbuf( stderr, NULL, _IONBF, 0 );

  // ****************************************************************
  // make cout, wcout, cin, wcin, wcerr, cerr, wclog and clog
  // point to console as well
  // ****************************************************************

//  ios::sync_with_stdio();
}

// ****************************************************************************
