// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef __PLAYBACK_THREAD_H__
#define __PLAYBACK_THREAD_H__

#include <wx/thread.h>
#include <wx/wx.h>
#include "Data.h"

// Define the ID for events that is sent to the GUI treat.
static const int PLAYBACK_THREAD_EVENT = 54321;

// ****************************************************************************
/// This class encapsulates the thread that performs the playback of the
/// film.
/// The actual computation is done in void *Entry(), which is executed when
/// wxThread::Run() is called from an other thread.
/// To terminate the thread before it finishes by itself, call 
/// cancelNow(). 
/// During execution, the thread continually posts events
/// (PLAYBACK_THREAD_EVENT) to the GUI thread, which contains the index of the
/// frame to display.
/// When the thread finished, it sends the value -1. 
/// When the GUI thread updated the GUI in response to such an event, it must 
/// call signalGuiUpdateFinished() to tell the thread to continue its operation.
// ****************************************************************************

class PlaybackThread : public wxThread
{
  // **************************************************************************
  // **************************************************************************

public:
  PlaybackThread(wxWindow *window);
  inline void cancelNow() { canceled = true; }
  inline bool wasCanceled() { return canceled; }
  inline void signalGuiUpdateFinished() { guiUpdateFinished = true; }
  void setFrameRange(int firstFrame, int lastFrame);


  // Thread execution starts here
  virtual void *Entry();

  // Called when the thread exits (normally or with Delete()), but not when it is killed
  virtual void OnExit();

  // **************************************************************************
  // **************************************************************************

private:
  wxWindow *window;
  bool canceled;
  bool guiUpdateFinished;
  int firstFrame;
  int lastFrame;
};

// ****************************************************************************

#endif
