// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef _MAIN_WINDOW_H_
#define _MAIN_WINDOW_H_

#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/filename.h>
#include <wx/spinctrl.h>
#include <wx/progdlg.h>

#include "Data.h"
#include "FilmPicture.h"
#include "SignalPicture.h"
#include "PlaybackThread.h"

// ****************************************************************************
// Main window of the application.
// ****************************************************************************

class MainWindow : public wxFrame
{
  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  MainWindow(wxWindow *parent, wxWindowID id = wxID_ANY, const wxString &title = wxEmptyString);
  void initWidgets();
  void updateWidgets();
  void updateScrollbar();
  
  // ****************************************************************************
  // Private data.
  // **************************************************************************

private:
  Data *data;

  wxMenuBar *menuBar;
  wxProgressDialog *progressDialog;
  PlaybackThread *playbackThread;

  // Side frame widgets
  wxRadioBox *radImageType;
  wxCheckBox *chkSeedThresholdCoupling;
  wxCheckBox *chkShowGlottisArea;
  wxCheckBox *chkShowGlottisEdge;

  // Main frame widgets
  FilmPicture *bigPicture;
  FilmPicture *smallPicture1;
  FilmPicture *smallPicture2;
  SignalPicture *signalPicture;
  wxScrollBar *scrFrameIndex;
  wxScrollBar *scrSignals;
  wxSpinCtrl *ctrlPlaybackSpeed;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  // Window events
  void OnCloseWindow(wxCloseEvent &event);

  // Menu functions
  void OnLoadAviFilm(wxCommandEvent &event);
  void OnLoadRawFilm(wxCommandEvent &event);
  void OnLoadBmpSequence(wxCommandEvent &event);
  void OnLoadSegmentationData(wxCommandEvent &event);
  void OnSaveSegmentationData(wxCommandEvent &event);
  void OnExportGlottisArea(wxCommandEvent &event);
  void OnExportGlottisContour(wxCommandEvent &event);
  void OnExit(wxCommandEvent &event);
  void OnAbout(wxCommandEvent &event);

  // Handlers for side frame controls
  void OnSelectImageType(wxCommandEvent &event);

  void OnSeedThresholdCoupling(wxCommandEvent &event);
  void OnShowGlottisArea(wxCommandEvent &event);
  void OnShowGlottisEdge(wxCommandEvent &event);
  void OnClearSegmentationData(wxCommandEvent &event);
  void OnCalcGlottalAreaCurve(wxCommandEvent &event);
  
  // Handlers for main frame controls
  void OnPlaybackThreadEvent(wxCommandEvent& event);
  void OnToStart(wxCommandEvent &event);
  void OnStartPlayback(wxCommandEvent &event);
  void OnStartSelectionPlayback(wxCommandEvent &event);
  void OnPlaybackSpeedChanged(wxSpinEvent &event);
  void OnFrameIndexScroll(wxScrollEvent &event);
  void OnSignalPictureScroll(wxScrollEvent &event);

  // Special shortcuts
  void OnKeyCtrlLeft(wxCommandEvent &event);
  void OnKeyCtrlRight(wxCommandEvent &event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif
