// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef __IMAGE_PROC_H__
#define __IMAGE_PROC_H__

#include <wx/wx.h>
#include <vector>
#include "Film.h"
#include "Data.h"

using namespace std;


// ****************************************************************************
/// Static class for image processing functions.
// ****************************************************************************

class ImageProc
{
  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  static wxImage getEdgeImage(wxImage *sourceImage);
  static wxImage getAlignedEdgeImage(wxImage *sourceImage, double glottisAxisAngle_deg);
  static int segmentGlottis(wxImage *sourceImage, int segmentMatrix[],
    int leftContour[], int rightContour[], Data::SrgData *srgData);

  static void getRowThresholds(Data::SrgData *srgData, int rowThreshold[]);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  static const int NUM_PIXELS = Film::WIDTH * Film::HEIGHT;
  static float xMatrix[NUM_PIXELS];
  static float yMatrix[NUM_PIXELS];
  static float gradientMagnitude[NUM_PIXELS];

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  static void imageToMatrix(wxImage *image, float matrix[]);
  static wxImage matrixToImage(float matrix[], bool bipolar);
  static void filterMatrix3x3(float sourceMatrix[], float targetMatrix[], float filter3x3[]);
  static void normalizeMatrix(float matrix[], bool bipolar);
  static void removeHighlights(float matrix[]);
};

#endif
