// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef __FILM_PICTURE_H__
#define __FILM_PICTURE_H__

#include <wx/wx.h>
#include "BasicPicture.h"
#include "Data.h"

// ****************************************************************************
/// The picture widget on the screen.
// ****************************************************************************

class FilmPicture : public BasicPicture
{
  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  FilmPicture(wxWindow *parent, int pictureIndex);
  virtual void draw(wxDC &dc);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  wxImage *image;
  int pictureIndex;
  Data *data;

  wxMenu *contextMenu;
  int selectedSeed;
  int selectedThresholdPoint;
  int menuX, menuY;
  int lastMx, lastMy;
  bool showSeeds;
  bool showThreshold;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void OnMouseEvent(wxMouseEvent &event);
  void OnUserDefinedSegmentation(wxCommandEvent &event);
  void OnShowSeeds(wxCommandEvent &event);
  void OnShowThreshold(wxCommandEvent &event);
  void OnToCurrentImage(wxCommandEvent &event);
  void OnToSideImage1(wxCommandEvent &event);
  void OnToSideImage2(wxCommandEvent &event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif

// ****************************************************************************
