// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef __FILM_H__
#define __FILM_H__

#include <wx/wx.h>


// ****************************************************************************
/// Class for a whole film. Contains the raw data.
// ****************************************************************************

class Film
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  static const int WIDTH = 256;
  static const int HEIGHT = 256;
  static const int MAX_FRAMES = 10000;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  Film();
  bool loadRawFilm(wxString fileName);
  bool loadAviFilm(wxString fileName);
  bool loadBmpSequence(wxString folderName);
  wxImage getFrame(int frameIndex);
  int getNumFrames();
  void clear();

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  bool isRawData;
  unsigned char *rawData;
  wxImage *images;
  int numFrames;
  
  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  wxImage extractFrame(int frameIndex);
};

#endif
