// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef ___DATA__
#define ___DATA__

#include <wx/wx.h>
#include <string>
#include <vector>

#include "Film.h"

using namespace std;

// ****************************************************************************
/// Singleton class containing the data and common methods for the frontend 
/// classes.
// ****************************************************************************

class Data
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  static const int NUM_DISPLAYED_FRAMES = 3;

  enum ImageType
  {
    COLOR_IMAGE,
    GRAYSCALE_IMAGE,
    EDGE_IMAGE,
    ALIGNED_EDGE_IMAGE,
    NUM_IMAGE_TYPES
  };

  // Data for seeded region growing in an image.
  // Number of threshold points and number of seeds must be equal,
  // because they can be coupled.
  
  static const int NUM_THRESHOLD_POINTS = 3;
  static const int NUM_SEEDS = NUM_THRESHOLD_POINTS;

  struct SrgData
  {
    bool isUserDefinedSegmentation;
    int thresholdY[NUM_THRESHOLD_POINTS];
    int thresholdValue[NUM_THRESHOLD_POINTS];
    wxPoint seed[NUM_SEEDS];
    int glottisArea_pix;
  };

  wxString programPath;
  wxString filmFileName;
  wxString bmpFolderName;
  wxString areaFileName;
  wxString contourFileName;
  wxString segmentationFileName;

  Film *film;
  int frameIndex[NUM_DISPLAYED_FRAMES];
  int selectionIndex[2];
  int imageType;
  int playbackSpeed_percent;

  SrgData *srgData;
  bool seedThresholdCoupling;
  bool showGlottisArea;
  bool showGlottisEdge;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  static Data *getInstance();
  void init(char *arg0);
  void resetSrgData();
  int getCurrFrameIndex(int pictureIndex = 0);
  void interpolateSrgData();

  bool loadSegmentationData(const char *fileName);
  bool saveSegmentationData(const char *fileName);
  bool exportGlottisArea(const char *fileName);
  bool exportGlottisContour(const char *fileName);

  // **************************************************************************
  // Private data.       
  // **************************************************************************

private:
  static Data *instance;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  Data();
};

#endif

// ****************************************************************************

